import sys
from collections import deque

def main():
    data = list(map(int, sys.stdin.buffer.read().split()))
    if not data:
        return

    it = iter(data)
    n = next(it)
    q = next(it)

    INF = q + 5

    a = [[INF] * n for _ in range(n)]
    for i in range(q):
        x = next(it) - 1
        y = next(it) - 1
        row = a[x]
        v = row[y]
        if i < v:
            row[y] = i

    res = [INF] * (n + 1)

    range_n = range(n)

    for i in range_n:
        ans = [-1] * n
        for j in range(i, n):
            row_j = a[j]
            for k in range_n:
                v = row_j[k]
                if v > ans[k]:
                    ans[k] = v

            m = j - i + 1

            dq = deque()
            dq_append = dq.append
            dq_pop = dq.pop
            dq_popleft = dq.popleft
            ak = ans

            for k in range_n:
                val = ak[k]
                while dq and dq[-1] < val:
                    dq_pop()
                dq_append(val)

                if k >= m - 1:
                    f = dq[0]
                    if f < res[m]:
                        res[m] = f

                    leaving = ak[k - m + 1]
                    if dq and dq[0] == leaving:
                        dq_popleft()

    res[0] = 0

    out_lines = []
    out_append = out_lines.append

    out_append("0")

    j = 0
    for i in range(q):
        while j <= n and res[j] <= i:
            j += 1
        out_append(str(j - 1))

    sys.stdout.write("\n".join(out_lines))


if __name__ == "__main__":
    main()

