import sys

MOD = 1_000_000_007
sys.setrecursionlimit(1_000_000)


def cross_contrib(a, L, R):
    if L >= R:
        return 0
    M = (L + R) // 2
    if M == R:
        return 0

    lenL = M - L + 1
    lenR = R - (M + 1) + 1

    leftMin = [0] * lenL
    leftMax = [0] * lenL
    rightMin = [0] * lenR
    rightMax = [0] * lenR

    v = a[M]
    leftMin[0] = v
    leftMax[0] = v
    for idx in range(1, lenL):
        pos = M - idx
        v = a[pos]
        prevMin = leftMin[idx - 1]
        prevMax = leftMax[idx - 1]
        if v < prevMin:
            leftMin[idx] = v
        else:
            leftMin[idx] = prevMin
        if v > prevMax:
            leftMax[idx] = v
        else:
            leftMax[idx] = prevMax

    v = a[M + 1]
    rightMin[0] = v
    rightMax[0] = v
    for idx in range(1, lenR):
        pos = M + 1 + idx
        v = a[pos]
        prevMin = rightMin[idx - 1]
        prevMax = rightMax[idx - 1]
        if v < prevMin:
            rightMin[idx] = v
        else:
            rightMin[idx] = prevMin
        if v > prevMax:
            rightMax[idx] = v
        else:
            rightMax[idx] = prevMax

    prefRightMax = [0] * lenR
    prefLeftMax = [0] * lenL

    s = 0
    for i in range(lenR):
        s += rightMax[i]
        s %= MOD
        prefRightMax[i] = s

    s = 0
    for i in range(lenL):
        s += leftMax[i]
        s %= MOD
        prefLeftMax[i] = s

    ans = 0

    pr = -1
    q = -1

    lenR_local = lenR
    lenL_local = lenL
    rightMin_local = rightMin
    rightMax_local = rightMax
    leftMin_local = leftMin
    leftMax_local = leftMax
    prefRightMax_local = prefRightMax

    for iIdx in range(lenL_local):
        Lmin = leftMin_local[iIdx]
        Lmax = leftMax_local[iIdx]
        Lmin_mod = Lmin % MOD
        Lmax_mod = Lmax % MOD

        while pr + 1 < lenR_local and rightMin_local[pr + 1] >= Lmin:
            pr += 1
        if pr < 0:
            continue

        while q + 1 < lenR_local and rightMax_local[q + 1] <= Lmax:
            q += 1

        t1 = q if q < pr else pr

        if t1 >= 0:
            cnt1 = t1 + 1
            sumR_greater = prefRightMax_local[pr] - prefRightMax_local[t1]
        else:
            cnt1 = 0
            sumR_greater = prefRightMax_local[pr]

        sumR_greater %= MOD
        inside = (Lmax_mod * (cnt1 % MOD) + sumR_greater) % MOD
        ans = (ans + Lmin_mod * inside) % MOD

    pl = -1
    qq = -1

    prefLeftMax_local = prefLeftMax

    for jIdx in range(lenR_local):
        Rmin = rightMin_local[jIdx]
        Rmax = rightMax_local[jIdx]
        Rmin_mod = Rmin % MOD
        Rmax_mod = Rmax % MOD

        while pl + 1 < lenL_local and leftMin_local[pl + 1] > Rmin:
            pl += 1
        if pl < 0:
            continue

        
        while qq + 1 < lenL_local and leftMax_local[qq + 1] <= Rmax:
            qq += 1

        t2 = qq if qq < pl else pl
        
        if t2 >= 0:
            cnt1 = t2 + 1
            sumLeft_greater = prefLeftMax_local[pl] - prefLeftMax_local[t2]
        else:
            cnt1 = 0
            sumLeft_greater = prefLeftMax_local[pl]

        sumLeft_greater %= MOD
        inside = (Rmax_mod * (cnt1 % MOD) + sumLeft_greater) % MOD
        ans = (ans + Rmin_mod * inside) % MOD

    return ans % MOD


def solve_rec(a, L, R):
    if L == R:
        v = a[L] % MOD
        return (v * v) % MOD
    M = (L + R) // 2
    left = solve_rec(a, L, M)
    right = solve_rec(a, M + 1, R)
    cross = cross_contrib(a, L, R)
    res = left + right + cross
    if res >= MOD:
        res %= MOD
    return res


def main():
    data = sys.stdin.buffer.read().split()
    if not data:
        return
    it = iter(data)
    n = int(next(it))
    a = [int(next(it)) for _ in range(n)]
    ans = solve_rec(a, 0, n - 1) % MOD
    sys.stdout.write(str(ans))


if __name__ == "__main__":
    main()

